<?php

namespace App\Http\Controllers;
use App\Models\Postevents;
use Illuminate\Http\Request;

class EventsPostCotroller extends Controller
{

    public function index()

    {

        $events = Postevents::latest()->paginate(5);
        return view('events.index',compact('events'))
            ->with('i', (request()->input('page', 1) - 1) * 5);

    }


        public function create()
    {
        return view('events.create');

    }


        public function store(Request $request)

    {

        $request->validate([


 'eventDescription',

            'eventCategory' => 'required',

            'eventDescription' => 'required',

            'start_date' => 'required',

           'end_date' => 'required',

            'location' => 'required',

             'latitude' => 'required',

             'longitude' => 'required',


            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        ]);



        $input = $request->all();



        if ($image = $request->file('image')) {

            $destinationPath = 'images/';

            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();

            $image->move($destinationPath, $profileImage);

            $input['image'] = "$profileImage";

        }



        Product::create($input);
        return redirect()->route('events.index')

                        ->with('success','Product created successfully.');

    }



    public function show(Postevents $events)

    {

        return view('events.show',compact('events'));

    }



        public function edit(Postevents $events)

    {

        return view('events.edit',compact('events'));

    }





        public function update(Request $request, Postevents $events)

    {

        $request->validate([

         'eventCategory' => 'required',

            'eventDescription' => 'required',

            'start_date' => 'required',

           'end_date' => 'required',

            'location' => 'required',

             'latitude' => 'required',

             'longitude' => 'required',



        ]);



        $input = $request->all();



        if ($image = $request->file('image')) {

            $destinationPath = 'images/';

            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();

            $image->move($destinationPath, $profileImage);

            $input['image'] = "$profileImage";

        }else{

            unset($input['image']);

        }



        $product->update($input);

        return redirect()->route('events.index')

                        ->with('success','Event updated successfully');

    }

        public function destroy(Postevents $events)

    {

        $product->delete();

        return redirect()->route('events.index')

                        ->with('success','Events deleted successfully');

    }

}
