<?php


use Illuminate\Support\Facades\Route;

use App\Http\Controllers\CustomAuthController;
use app\Http\Controllers\HomeController;
use app\Http\Controllers\EventsPostCotroller;

/*

|--------------------------------------------------------------------------

| Web Routes

|--------------------------------------------------------------------------

|

| Here is where you can register web routes for your application. These

| routes are loaded by the RouteServiceProvider within a group which

| contains the "web" middleware group. Now create something great!

|

*/


Route::get('dashboard', [CustomAuthController::class, 'dashboard']);

Route::get('login', [CustomAuthController::class, 'index'])->name('login');

Route::post('custom-login', [CustomAuthController::class, 'customLogin'])->name('login.custom');

Route::get('registration', [CustomAuthController::class, 'registration'])->name('register-user');

Route::post('custom-registration', [CustomAuthController::class, 'customRegistration'])->name('register.custom');

Route::get('signout', [CustomAuthController::class, 'signOut'])->name('signout');


//main Controller
Route::get('index', [CustomAuthController::class, 'home'])->name('index');


//Post event route
Route::resource('products', EventsPostCotroller::class);
